/*

Autor:  Josef Bernhardt

Hardware: ESP8266 Node MCU

Software: Arduino IDE

Bad Abbach 12.2.2021

Programm for sending data per HTTP Post to my webserver  PHP software

Reading Data from webserver PHP software


aktion=sql_xml_cmd&sql=select * from table

aktion=sql_csv_cmd&sql=select * from table

aktion=sql_csv_cmd&sql=show tables

aktion=sql_xml_cmd&sql=select * from table


aktion=write&file=messwerte.csv&inhalt=Test

aktion=read&file=messwerte.csv

aktion=info&inhalt=Hallo vom Server

aktion=sendmail&inhalt=Das ist ein Testtext

INSERT INTO `messwerte` (`date`, `temperatur`) VALUES (CURRENT_DATE(), '22.4');
 
*/

#include <ESP8266WiFi.h>
#include <ESP8266HTTPClient.h>
#include <WiFiClient.h>


#define ESP_PIN_D0   16    // A1
#define ESP_PIN_D1   5     // A2
#define ESP_PIN_D2   4     // A3
#define ESP_PIN_D3   0     // A4
#define ESP_PIN_D4   2     // ONE Wire
#define ESP_PIN_D5   14    // MUX_IN
#define ESP_PIN_D6   12    // MUX_A
#define ESP_PIN_D7   13    // MUX_B
#define ESP_PIN_D8   15    // PWM
#define ESP_PIN_ADC  A0    // ADC

// Variables for IN / OUT
bool esp_in_reg[4];
bool esp_out_reg[4];
uint16_t esp_adc_reg;

// Wlan Parameter
const char* ssid = "FRITZ!Box Fon WLAN 7170";
const char* password = "1234567890";

//Your Domain name with URL path or IP address with path
const char* serverName = "http://www.bernhardt.de/esp8266web/sqlabfrage.php";

// Time in milliseconds
unsigned long lastTime = 0;
// Set timer to 0.5 seconds (500)
unsigned long timerValue = 500;

// Init PIN I/O
void pinConfig()
{
    pinMode(ESP_PIN_D0, OUTPUT);
    pinMode(ESP_PIN_D1, OUTPUT);
    pinMode(ESP_PIN_D2, OUTPUT);
    pinMode(ESP_PIN_D3, OUTPUT);
    
    // MUX A
    pinMode(ESP_PIN_D6, OUTPUT);
    // MUX B    
    pinMode(ESP_PIN_D7, OUTPUT);
    // PWM
    pinMode(ESP_PIN_D8, OUTPUT);
    // Input
    pinMode(ESP_PIN_D5, INPUT);
}

// Read and write Pins
void updateIn()
{
     digitalWrite(ESP_PIN_D6, 0);  // MUX_A
     digitalWrite(ESP_PIN_D7, 0);  // MUX_B   
     delay(1);
     esp_in_reg[0] = digitalRead(ESP_PIN_D5);
    
     digitalWrite(ESP_PIN_D6, 1);  // MUX_A
     digitalWrite(ESP_PIN_D7, 0);  // MUX_B 
     delay(1);            
     esp_in_reg[1] = digitalRead(ESP_PIN_D5);  
       
     digitalWrite(ESP_PIN_D6, 0);  // MUX_A
     digitalWrite(ESP_PIN_D7, 1);  // MUX_B  
     delay(1);          
     esp_in_reg[2] = digitalRead(ESP_PIN_D5);   
      
     digitalWrite(ESP_PIN_D6, 1);  // MUX_A
     digitalWrite(ESP_PIN_D7, 1);  // MUX_B  
     delay(1);         
     esp_in_reg[3] = digitalRead(ESP_PIN_D5);
         
     esp_adc_reg = (analogRead(ESP_PIN_ADC));        
}

// Setup WLAN and I/O Pins
void setup() {
  Serial.begin(115200);
  delay(10);

  WiFi.begin(ssid, password);
  Serial.println("Connecting");
  while(WiFi.status() != WL_CONNECTED) 
  {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to WiFi network with IP Address: ");
  Serial.println(WiFi.localIP());
 
  Serial.println("Timer set to 1 second..");

  pinConfig();
  digitalWrite(ESP_PIN_D0, 0);
  digitalWrite(ESP_PIN_D1, 0);
  digitalWrite(ESP_PIN_D2, 0);
  digitalWrite(ESP_PIN_D3, 0);
  analogWrite(ESP_PIN_D8, 0);     // PWM  to zero
  updateIn();
}


// Read Analog Input and send Data to phpserver
// Read Digital Input and Output Pins and send Data to phpserver
// aktion=write&file=inputs.csv&inhalt="9.99;0;0;0;1;1;0;1;0
void SendInputs()
{
      HTTPClient http;
      updateIn();
      
      String A0  = String(esp_adc_reg*0.00975);
      //String A0  = String(esp_adc_reg);      
      String IN1 = String(esp_in_reg[0]);
      String IN2 = String(esp_in_reg[1]);
      String IN3 = String(esp_in_reg[2]);
      String IN4 = String(esp_in_reg[3]);

      // Read the State of the Output Ports
      String OUT1 = String(digitalRead(ESP_PIN_D0));
      String OUT2 = String(digitalRead(ESP_PIN_D1));
      String OUT3 = String(digitalRead(ESP_PIN_D2));
      String OUT4 = String(digitalRead(ESP_PIN_D3));

      String SendData = A0 +  ";" + IN1 +  ";"  + IN2 +  ";"  + IN3 +  ";"  + IN4 + ";" + OUT1 +  ";"  + OUT2 +  ";"  + OUT3 +  ";"  + OUT4   ;

      String httpRequestData = "aktion=write&file=inputs.csv&inhalt=" + SendData;    

      Serial.println(httpRequestData);
      
      // Your Domain name with URL path or IP address with path
      http.begin(serverName);

      // Specify content-type header
      http.addHeader("Content-Type", "application/x-www-form-urlencoded");
      // Data to send with HTTP POST
       
      // Send HTTP POST request
      int httpResponseCode = http.POST(httpRequestData);
      
      if (httpResponseCode > 0) 
      {
        String payload = http.getString();
        Serial.print("Data: ");
        Serial.println(payload);  
        Serial.print("HTTP Response code: ");
        Serial.println(httpResponseCode);
      }
      else
      {
        Serial.print("Error code: ");
        Serial.println(httpResponseCode);
      }
      // Free resources
      http.end();  
}

// Read Digital Button State from Server and Write Output Pins D0 to D3
// aktion=read&file=out1.csv
// aktion=read&file=out2.csv
// aktion=read&file=out3.csv
// aktion=read&file=out4.csv
void ReadInputsOut(int pin)
{
      HTTPClient http;

      String httpRequestData = "aktion=read&file=out1.csv";    

      switch (pin) 
      {
         case 1:httpRequestData = "aktion=read&file=out1.csv"; break;
         case 2:httpRequestData = "aktion=read&file=out2.csv"; break;     
         case 3:httpRequestData = "aktion=read&file=out3.csv"; break;
         case 4:httpRequestData = "aktion=read&file=out4.csv"; break;             
      }
      Serial.println(httpRequestData);
      
      // Your Domain name with URL path or IP address with path
      http.begin(serverName);

      // Specify content-type header
      http.addHeader("Content-Type", "application/x-www-form-urlencoded");
      // Data to send with HTTP POST
       
      // Send HTTP POST request
      int httpResponseCode = http.POST(httpRequestData);
      
      if (httpResponseCode > 0) 
      {
        String payload = http.getString();
        Serial.print("Data: ");
        Serial.println(payload);  
        Serial.print("HTTP Response code: ");
        Serial.println(httpResponseCode);
         
        switch (pin) 
        {

         case 1:if (payload == "ON") digitalWrite(ESP_PIN_D0, 1); else digitalWrite(ESP_PIN_D0, 0);break;
         case 2:if (payload == "ON") digitalWrite(ESP_PIN_D1, 1); else digitalWrite(ESP_PIN_D1, 0);break;     
         case 3:if (payload == "ON") digitalWrite(ESP_PIN_D2, 1); else digitalWrite(ESP_PIN_D2, 0);break;
         case 4:if (payload == "ON") digitalWrite(ESP_PIN_D3, 1); else digitalWrite(ESP_PIN_D3, 0);break;            
       }     
       
      }
      else
      {
        Serial.print("Error code: ");
        Serial.println(httpResponseCode);
      }
      // Free resources
      http.end();    
}

// Read Analog Value from Server and Write PWM PIN
// aktion=read&file=analogin.csv
void ReadAnalogOut()
{
      HTTPClient http;

      String httpRequestData = "aktion=read&file=analogin.csv";    

      Serial.println(httpRequestData);
      
      // Your Domain name with URL path or IP address with path
      http.begin(serverName);

      // Specify content-type header
      http.addHeader("Content-Type", "application/x-www-form-urlencoded");
       
      // Send HTTP POST request
      int httpResponseCode = http.POST(httpRequestData);
      
      if (httpResponseCode > 0) 
      {
        String payload = http.getString();

        
        // 0 to 10V to 0..1023 
        float pwmvalue = payload.toFloat() * 102.4;

        int x = (int)pwmvalue;

        analogWrite(ESP_PIN_D8,x); // ca 1.2 KHz
        
        Serial.print("Data: ");
        Serial.println(payload);  
        Serial.print("HTTP Response code: ");
        Serial.println(httpResponseCode);
       }
      else
      {
        Serial.print("Error code: ");
        Serial.println(httpResponseCode);
      }
      // Free resources
      http.end();     
}

// Main loop
void loop() 
{
    //Send an HTTP POST request every second
    if ((millis() - lastTime) > timerValue) 
    {
    //Check WiFi connection status
    if(WiFi.status()== WL_CONNECTED)
    {
        SendInputs();
        ReadInputsOut(1);
        ReadInputsOut(2);
        ReadInputsOut(3);
        ReadInputsOut(4);  
        ReadAnalogOut();     
    }
    else 
	  {
      Serial.println("WLAN not connected");
	  }
      lastTime = millis();
    }
}
